//misc utilities

#ifndef UTIL_H
#define	UTIL_H
#include <xc.h>
#include "io.h"

//series test resistor
#define VOLUME_DEFAULT (128)
//open circuit threshold, different for diodes due to leakage
//used for volume values
#define VOLUME_VAL_LOWER (0)
#define VOLUME_VAL_UPPER (255)

#define _XTAL_FREQ 4000000
#define Volume_Delay_Ms 20
/* IR Stuff */
#define TimerMax 0xFFFF
#define S1_IR_Interval_Overflow 1000   /* The bit time is 1778us so low time 730 ish */
#define S2_IR_Interval_Overflow 1000   /* The bit time is 1778us so to next low 1770 isn*/
#define S3_IR_Interval_Overflow 3000   /* The bit time is 1778us so to next low 1770 isn*/
#define settle_time_IR_Read     10      /* milliseconds */
#define startup_delay 255

/* Rotary Encoder Stuff */
#define Slow_Fast_Count 8  /* after which we go to fast steps */
#define Fast_Slow_Count 20000 /* after which we go back to slow */
#define Fast_Steps  6       /* this is 3dB per click */
#define Slow_Steps  1       /* this is 0.5dB per click */
#define Volume_Up_IR 16     /* volume up philips command */
#define Volume_Down_IR 17   /* volume down philips command */
#define Volume_Mute_IR 13   /* Mute philips command */
#define Volume_Address_IR 0
#define Volume_Address_IR_RCVR 16
#define Save_Timer_Val  65535 /* bake this a big time */
#define Mute_Delay_ms  100    /* a pause after mute command received */
#define Volume_Delay_ms  50    /* a pause after mute command received */
#define IR_Fine_Tune_Magic_Number -00 /* magic number that accounts fo delays */
#define Flash_Init_Byte_0   84 /* ASCII T */
#define Flash_Init_Byte_1   103 /* ASCII g */
#define Flash_Init_Byte_2   109 /* ASCII m */

long vf,vr; //forward and reverse ADC, used as globals
extern unsigned long bvolt; //battery voltage, set by main()
extern long t;              //needed for showD()

typedef enum
{
	/* Application's state machine's initial state. */
	VOLUME_STATE_INIT=0,                              // Initial state
	VOLUME_STATE_IDLE                          // Idle
            
	/* TODO: Define states used by the application state machine. */
} VOLUME_STATES;

typedef struct
{
    VOLUME_STATES       state;              /* The application's current state */
    int                 Volume;             /* Volume */
    unsigned int        Timer_Time;         /* Duration for timer mode and old setting */
    unsigned int        Timer_Temp;         /* Temp for timer mode */
    unsigned int        Interval;           /* IR interval */
    unsigned int        Sample_Time;        /* Time for next sample */   
    char                ROT_State;          /* rotary Encoder State */
    char                ROT_State_Prev;     /* Prev rotary Encoder State */
    char                IR_State;           /* IR Input State */
    char                IR_State_Prev;      /* IR Input State */
    char                Valid_Input;        /* flag for valid data */
    char                Action;             /* what to do */
    char                Increment;          /* Volume Increment */
    int                 Slow_Loops;         /* slow loop counter */
    int                 Fast_Loops;         /* fast loop counter */
    char                TimeOut;            /* used on IR Rx */
    char                Toggle;             /* toggle bit */
    char                Address;            /* toggle bit */
    char                Command;            /* toggle bit */
    unsigned int        Save_Timer;         /* timer for saving current volume */
    char                Data_To_Save;       /* flag there is data to save */
    char                Mute;               /* flag to say mute the output */
    int                 Source;             /* Source: TV =1, RCVR = 0 */ 
    int                 Check_Byte_0;       /* used to check if FLASH has been initialised */   
    int                 Check_Byte_1;       /* used to check if FLASH has been initialised */   
    int                 Check_Byte_2;       /* used to check if FLASH has been initialised */ 
    int                 IR_Addr;            /* store the IR Address to look for */
} VOLUME_DATA;

VOLUME_DATA Volume_Data;   /* refer defines in util.h */

/* define the PORA A bits here    */
/* Note io.c sets these port bits */
#define ROT_B 0x20         /* pora A bit 5 */
#define ROT_A 0x10         /* pora A bit 4 */
#define IR_IN 0x08         /* pora A bit 3 */
#define TV_Port 0x02       /* bit 1 of port A */ 
#define RCVR_Port 0x01     /* bit 0 of port A */ 
#define PORT_BITS (ROT_B + ROT_A + IR_IN)
#define REM_BITS (TV_Port + RCVR_Port)
#define ROT_ENC_CHANGE (!)
#define ROTARY_ENC_SETTLE 500 /* 500us */
#define Phase0 (ROT_A + ROT_B)
#define Phase1 (ROT_A)
#define Phase2 (00)
#define Phase3 (ROT_B)
#define No_Action 0
#define Volume_Up 1
#define Volume_Down 2
#define Volume_Mute 3


void sleepDelay(void);                  //nominally 200ms for legible display updates
void loadVolFromFlash(void);            //custom wrapper for this program
void SaveVolToFlash(void);              //custom wrapper for this program
void loadRemCodeFromFlash(void);

#endif

